require("stategraphs/commonstates")

local actionhandlers = 
{
	ActionHandler(ACTIONS.HAMMER, "attack"),
	ActionHandler(ACTIONS.GOHOME, "taunt"),
}

local function onattackfn(inst)
    if inst.components.health and not inst.components.health:IsDead()
       and (inst.sg:HasStateTag("hit") or not inst.sg:HasStateTag("busy")) then
        if inst.CanFreeze then
            inst.sg:GoToState("freeze")
        else
            inst.sg:GoToState("attack")
        end
    end
end

local SHAKE_DIST = 40

local function DeerclopsFootstep(inst)
    inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/step")
    local player = GetClosestInstWithTag("player", inst, SHAKE_DIST)
    if player then
        player.components.playercontroller:ShakeCamera(inst, "VERTICAL", 0.5, 0.03, 2, SHAKE_DIST)
    end
end

local function SpawnIceFx(inst, target)
    if not inst or not target then return end
    local numFX = math.random(15,20)
    local pos = inst:GetPosition()
    local targetPos = target:GetPosition()
    local vec = targetPos - pos
    vec = vec:Normalize()
    local dist = pos:Dist(targetPos)
    local angle = inst:GetAngleToPoint(targetPos:Get())

    for i = 1, numFX do
        inst:DoTaskInTime(math.random() * 0.25, function(inst)
            local prefab = "icespike_fx_"..math.random(1,4)
            local fx = SpawnPrefab(prefab)
            if fx then
                local x = GetRandomWithVariance(0, 3)
                local z = GetRandomWithVariance(0, 3)
                local offset = (vec * math.random(dist * 0.25, dist)) + Vector3(x,0,z)
                fx.Transform:SetPosition((offset+pos):Get())
            local pt = fx:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 1)
    for k,v in pairs(ents) do
        if v and v.components.workable and v.components.workable.workleft > 0 then
            SpawnPrefab("collapse_small").Transform:SetPosition(v:GetPosition():Get())        
            v.components.workable:Destroy(inst)
        end
            if v.components.combat and v ~= inst and v.prefab ~= "deerclops" and v.prefab ~= "crawlinghorror" and v.prefab ~= "terrorbeak" and v.prefab ~= "crawlingnightmare" and v.prefab ~= "nightmarebeak" then
            v.components.combat:GetAttacked(inst, 3)
            if not v.components.freezable then
            return
        else
            v.components.freezable:AddColdness(-2)
            					end
                            end
                        end
            		end
        		end)
    		end
    	end

local function Freeze(inst)
    local numFX = 20
    local pos = inst:GetPosition()

    for i = 1, numFX do
        inst:DoTaskInTime(math.random() * 0.25, function(inst)
            local prefab = "icespike_fx_"..math.random(1,4)
            local fx = SpawnPrefab(prefab)
            if fx then
            	fx.Transform:SetScale(3,3,3)
                local rad = math.random(12.5)
    			local angle = math.random() * 2 * PI
                local offset = Vector3(rad * math.cos(angle), 0, -rad * math.sin(angle))
                fx.Transform:SetPosition((offset+pos):Get())
                fx.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/ice_large")
            local pt = fx:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 3)
    for k,v in pairs(ents) do
        if v and v.components.workable and v.components.workable.workleft > 0 then
            SpawnPrefab("collapse_small").Transform:SetPosition(v:GetPosition():Get())        
            v.components.workable:Destroy(inst)
        end
            if v.components.combat and v ~= inst and v.prefab ~= "deerclops" and v.prefab ~= "crawlinghorror" and v.prefab ~= "terrorbeak" and v.prefab ~= "crawlingnightmare" and v.prefab ~= "nightmarebeak" then
            v.components.combat:GetAttacked(inst, 100)
            if not v.components.freezable then
            return
        else
            v.components.freezable:AddColdness(4)
            			end
                    end
        		end
    		end
    	end)
	end
end

local events=
{
    CommonHandlers.OnLocomote(false,true),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnFreeze(),
    CommonHandlers.OnAttacked(),
    CommonHandlers.OnDeath(),
    EventHandler("doattack", onattackfn),
}

local states=
{
    State{
        name = "gohome",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("taunt")
            inst:ClearBufferedAction()
            inst.components.knownlocations:RememberLocation("home", nil)
        end,
        
        timeline=
        {
            TimeEvent(5*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_grrr") end),
            TimeEvent(16*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_howl") end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },      
    
	State{
        name = "taunt",
        tags = {"busy", "taunt"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("taunt")
            
            if inst.bufferedaction and inst.bufferedaction.action == ACTIONS.GOHOME then
                inst:ClearBufferedAction()
                inst.components.knownlocations:RememberLocation("home", nil)
            end
        end,
        
        timeline=
        {
            TimeEvent(5*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_grrr") end),
            TimeEvent(16*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_howl") Freeze(inst) end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) 
            inst.components.combat:SetRange(10.5)
            inst.sg:GoToState("idle")
            end),
        },
    },

    State{
        name = "freeze",
        tags = {"busy"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("taunt")
            
            if inst.bufferedaction and inst.bufferedaction.action == ACTIONS.GOHOME then
                inst:ClearBufferedAction()
                inst.components.knownlocations:RememberLocation("home", nil)
            end
        end,
        
        timeline=
        {
            TimeEvent(5*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_grrr") end),
            TimeEvent(16*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/taunt_howl") 
            inst.components.burnable:Extinguish()
            Freeze(inst) end),
        },
        
        events=
        {
            EventHandler("animover", function(inst)
            inst.CanFreeze = false 
            inst.components.combat:SetRange(10.5)            
            inst.sg:GoToState("idle") end),
        },
    },

}

CommonStates.AddWalkStates( states,
{
	starttimeline =
	{
        TimeEvent(7*FRAMES, DeerclopsFootstep),
	},
    walktimeline = 
    { 
        TimeEvent(23*FRAMES, DeerclopsFootstep),
        TimeEvent(42*FRAMES, DeerclopsFootstep),
    },
    endtimeline=
    {
        TimeEvent(5*FRAMES, DeerclopsFootstep),
    },
})

CommonStates.AddCombatStates(states,
{
	hittimeline =
	{
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/hurt") end),
	},
    attacktimeline = 
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/attack") end),
        TimeEvent(29*FRAMES, function(inst) SpawnIceFx(inst, inst.components.combat.target) end),
        TimeEvent(35*FRAMES, function(inst)            
            inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/ice_large")            
            inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/swipe")
            inst.components.burnable:Extinguish()
            inst.components.combat:DoAttack(inst.sg.statemem.target)
            if not inst.components.timer:TimerExists("Freeze") then
                inst.components.timer:StartTimer("Freeze", 10)
            end
            if inst.bufferedaction and inst.bufferedaction.action == ACTIONS.HAMMER then
                inst.bufferedaction.target.components.workable:SetWorkLeft(1)
                inst:PerformBufferedAction()
            end
            local player = GetClosestInstWithTag("player", inst, SHAKE_DIST)
            if player then
                player.components.playercontroller:ShakeCamera(inst, "FULL", 0.5, 0.05, 2, SHAKE_DIST)
            end
        end),
        TimeEvent(36*FRAMES, function(inst) inst.sg:RemoveStateTag("attack") end),
    },
    deathtimeline=
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/death") end),
        TimeEvent(50*FRAMES, function(inst)
            if GetSeasonManager():GetSnowPercent() > 0.02 then
                inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/bodyfall_snow")
            else
                inst.SoundEmitter:PlaySound("dontstarve/creatures/deerclops/bodyfall_dirt")
            end    
            local player = GetClosestInstWithTag("player", inst, SHAKE_DIST)
            if player then
                player.components.playercontroller:ShakeCamera(inst, "FULL", 0.7, 0.02, 3, SHAKE_DIST)
            end
        end),
    },
})

CommonStates.AddIdle(states)
CommonStates.AddSleepStates(states,
{
    sleeptimeline = 
    {
        --TimeEvent(46*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.sounds.grunt) end)
    },
})
CommonStates.AddFrozenStates(states)

return StateGraph("deerclops", states, events, "idle", actionhandlers)

